#include <Servo.h>  // Voeg de Servo bibliotheek toe
#include <CuteBuzzerSounds.h> //Bibliotheek voor de cute buzzer sound

// Definieer de pinnen voor de sensoren, servo's, LED's en buzzer
const int trigPin = 7;        // Trigger pin voor de sensor
const int echoPin = 8;        // Echo pin voor de sensor
const int doorServo1Pin = 10;  // Servo voor de eerste deur
const int doorServo2Pin = 6;  // Servo voor de tweede deur
const int redLEDPin = 11;     // Rood LED op PWM-pin
const int greenLEDPin = 12;   // Groen LED op PWM-pin
const int buzzerPin = 3;      // Buzzer pin

// Posities van de deuren
int closedPos = 0;  // Gesloten positie
int openPos = 90;   // Open positie

// Drempels voor de deur (afstanden in cm)
const int door1Threshold = 10; 
const int door2Threshold = 15;

// Servo objecten
Servo doorServo1;
Servo doorServo2;

// Variabelen voor het openen/sluiten van deuren
bool door1Open = false;
bool door2Open = false;

void setup() {
  Serial.begin(9600); //Monitor die alles meet
  
  pinMode(trigPin, OUTPUT);
  pinMode(echoPin, INPUT);
  pinMode(redLEDPin, OUTPUT);
  pinMode(greenLEDPin, OUTPUT);
  pinMode(buzzerPin, OUTPUT);

  doorServo1.attach(doorServo1Pin);
  doorServo2.attach(doorServo2Pin);

  doorServo1.write(closedPos); //De servo is aan het begin in gesloten positie
  doorServo2.write(closedPos);

  randomSeed(analogRead(0));
  randomPhoneLED(); //Random led dat gaat branden
  cute.init(buzzerPin);
}

void loop() {
  int distance = getDistance(); //Afstand meten

  Serial.print("Afstand: ");
  Serial.print(distance);
  Serial.println(" cm");

  if (distance > 0 && distance <= door1Threshold && !door1Open) {
    openDoor1(); //Deur die open gaat en dicht, als de afstand groter is dan 0 en kleiner 
    //of gelijk aan door1Threshold en de deur is open
    playMelody();
    fadeLEDs();
  } else if (distance > door1Threshold && distance <= door2Threshold && !door2Open) {
    closeDoor1();
    openDoor2();
    playMelody();
    fadeLEDs();
  } else if (distance > door2Threshold) {
    closeDoor1();
    closeDoor2();
  }
  delay(500); //Anders pauze
}

long getDistance() {
  digitalWrite(trigPin, LOW);
  delayMicroseconds(2);
  digitalWrite(trigPin, HIGH);
  delayMicroseconds(10);
  digitalWrite(trigPin, LOW);

  long duration = pulseIn(echoPin, HIGH);
  int distance = duration * 0.034 / 2; //Afstand berekenen
  return distance;
}

void openDoor1() {
  doorServo1.write(openPos); //Deur die open en dicht gaat
  randomPhoneLED(); //Willigkeurige lamp die gaat branden
  door1Open = true;
}

void openDoor2() {
  doorServo2.write(openPos);
  door2Open = true;
  randomPhoneLED();
}

void closeDoor1() {
  doorServo1.write(closedPos);
  door1Open = false;
}

void closeDoor2() {
  doorServo2.write(closedPos);
  door2Open = false;
}

void randomPhoneLED() {
  int randomValue = random(2); //Een willigkeurige getal wordt genegeert, dus 0 of 1, maar nooit 2
  if (randomValue == 0) { 
    fadeLED(redLEDPin);// Als randomValue = 0 dan gaat rood lampje branden en ook faden
  } else {
    fadeLED(greenLEDPin);
  }
}

void playMelody() {
  cute.play(S_HAPPY);
  delay(2000);
  cute.play(S_HAPPY);
  noTone(buzzerPin);
}

void fadeLED(int ledPin) {
  for (int brightness = 0; brightness <= 255; brightness++) {
    analogWrite(ledPin, brightness); //Fading van de led lamp van 0 naar 255 en elke keer + bij
    delay(10);
  }
  for (int brightness = 255; brightness >= 0; brightness--) {
    analogWrite(ledPin, brightness);
    delay(10);
  }
}
//Langzaam faden van de lichten
void fadeLEDs() {
  fadeLED(redLEDPin); //Fading van de leds
  fadeLED(greenLEDPin);
}

